<?php

namespace App\Http\Controllers\Admin;

use App\Classes\Files;
use App\Classes\Reply;
use App\Events\CreateEmployeeEvent;
use App\Exports\EmployeeExport;
use App\Http\Controllers\AdminBaseController;
use App\Http\Requests\Admin\Employee\CreateRequest;
use App\Http\Requests\Admin\Employee\UpdateRequest;
use App\Http\Requests\Admin\Employee\AdvanceRequest;
use App\Models\Bank_detail;
use App\Models\Department;
use App\Models\Designation;
use App\Models\Employee;
use App\Models\Employee_document;
use App\Models\Salary;
use App\Models\EmployeeAdvance;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\Response;




/**
 * Class EmployeesController
 * This Controller is for the all the related function applied on employees
 */
class EmployeesController extends AdminBaseController
{

    /**
     * Constructor for the Employees
     */

    public function __construct()
    {
        parent::__construct();
        $this->employeesOpen = 'active open';
        $this->pageTitle = 'Employees';
        $this->employeesActive = 'active';
    }

    public function index()
    {
        return View::make('admin.employees.index', $this->data);
    }

    /**
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
  public function ajaxEmployees()
{
 

    $result = Employee::select('id', 'employeeID', 'profileImage', 'email', 'fullName', 'designation', 'date_of_birth', 'status');
        // ->with('getDesignation:id,deptID,designation');

    return datatables()->eloquent($result)
        ->filter(function($query) {
            $searchValue = request()->get('search')['value'] ?? null;
            if ($searchValue) {
                $query->where('employeeID', 'LIKE', '%'.$searchValue.'%')
                      ->orWhere('email', 'LIKE', '%'.$searchValue.'%')
                      ->orWhere('fullName', 'LIKE', '%'.$searchValue.'%')
                      ->orWhereHas('getDesignation', function($q) use ($searchValue) {
                          $q->where('designation', 'LIKE', '%'.strtolower($searchValue).'%');
                      });
            }
        })
        ->editColumn('profileImage', function ($row) {
            return '<img src="' . $row->profile_image_url . '" height="80px" />';
        })
        ->editColumn('designation', function ($row) {
            return '<p>Department: <strong>' . (!is_null($row->getDesignation) ? $row->getDesignation->department->deptName : '-') . '</strong></p>
            <p>Designation: <strong>' . (!is_null($row->getDesignation) ? $row->getDesignation->designation : '-') . '</strong></p>';
        })
        ->editColumn('date_of_birth', function ($row) {
            return $row->workDuration($row->employeeID);
        })
        ->editColumn('status', function ($row) {
            $color = [
                'active' => 'success',
                'inactive' => 'danger'
            ];
            return '<span class="label label-' . $color[$row->status] . '">' . $row->status . '</span>';
        })
        ->addColumn('action', function ($row) {
            return '<p><a class="btn btn-sm purple" href="' . route('admin.employees.edit', $row->employeeID) . '"><i class="fa fa-edit"></i> View/Edit</a></p>
            <p><a class="btn btn-sm orange" href="' . route('admin.employees.get_advance', $row->employeeID) . '"><i class="fa fa-plus"></i>Add Advance</a></p>
            <p><a class="btn btn-sm red list-index" href="javascript:;" onclick="del(\'' . $row->id . '\')"><i class="fa fa-trash"></i> Delete</a></p>';
        })
        ->rawColumns(['profileImage', 'designation', 'status', 'action'])
        ->removeColumn('email', 'id')
        ->orderColumn('employeeID', function($query, $order) {
            // Cast employeeID to integer for sorting
            $query->orderByRaw('CAST(employeeID AS UNSIGNED) ' . $order);
        })
        ->make(true);
}

    /**
     * Show the form for creating a new employee
     */
    public function create()
    {
        $this->department = Department::pluck('deptName', 'id');

        return View::make('admin.employees.create', $this->data);
    }

    /**
     * @param CreateRequest $request
     * @return array
     * @throws \Exception
     */
    public function store(CreateRequest $request)
    {
        DB::beginTransaction();
        try {
     
            

            $employee = Employee::create($request->toArray());
            

            // Profile Image Upload
            if ($request->profileImage) {
                $file = new Files();
                $employee->profileImage = $file->upload($request->profileImage, 'employee');
                $employee->save();
            }

            // Insert into salary table
            if ($request->currentSalary != '') {
                Salary::create([
                    'employeeID' => $request->employeeID,
                    'type' => 'current',
                    'remarks' => 'Joining Salary Of Employee',
                    'salary_type' => $request->salary_type,
                    'salary' => $request->currentSalary

                ]);
            }

            // Insert Into Bank Details
            if ($request->accountName != '' && $request->accountNumber != '') {
                Bank_detail::create($request->toArray());
            }

            // UPLOAD THE DOCUMENTS  -----------------
            $documents = ['resume', 'offerLetter', 'joiningLetter', 'contract', 'IDProof'];

            foreach ($documents as $document) {

                if ($request->hasFile($document)) {
                    $file = new Files();
                    $filename = $file->upload(request()->file($document), 'employee_documents/' . $document, null, null, false);
                    Employee_document::create([
                        'employeeID' => $request->employeeID,
                        'fileName' => $filename,
                        'type' => $document
                    ]);
                }
            }


            if ($this->setting->employee_add == 1) {
                $this->employee_name = $request->fullName;
                $this->employee_email = $request->email;
                $this->employee_password = $request->password;
                // Send Employee Add Mail
                
                if($request->email)
                event(new CreateEmployeeEvent($employee, $request->password));
            }

            // END UPLOAD THE DOCUMENTS**********

        } catch (\Exception $e) {
            DB::rollback();
            throw $e;
        }

        DB::commit();
        return Reply::redirect(route('admin.employees.index'), '</strong> successfully added to the Database');
    }

    /**
     * Show the form for editing the specified employee
     */
    public function edit($id)
    {
        $this->employeesActive = 'active';
        $this->department = Department::pluck('deptName', 'id');
        $this->employee = Employee::where('employeeID', '=', $id)->get()->first();
        $this->designation = Designation::find($this->employee->designation);

        $doc = [];

        foreach ($this->employee->getDocuments as $documents) {
            $doc[$documents->type] = $documents->document_url;
        }

        $this->documents = $doc;

        $this->bank_details = Bank_detail::where('employeeID', '=', $id)->get()->first();
                $this->salary_details = Salary::where('employeeID', '=', $id)->first();


        return View::make('admin.employees.edit', $this->data);
    }

    /**
     * Update the specified employee in storage.
     */
    public function update(UpdateRequest $request, $id)
    {
        // Bank Details Update-------
        if ($request->updateType == 'bank') {
            $bankDetails = Bank_detail::firstOrNew(['employeeID' => $id]);
//            $bankDetails->update($request->toArray());
            $bankDetails->accountName = $request->accountName;
            $bankDetails->accountNumber = $request->accountNumber;
            $bankDetails->bank = $request->bank;
            $bankDetails->pan = $request->pan;
            $bankDetails->ifsc = $request->ifsc;
            $bankDetails->branch = $request->branch;
            $bankDetails->save();

            return Reply::success('Bank details updated successfully');

        }

        // Bank Details Update End--------
        // Company Details Update Start--------

        else if ($request->updateType == 'company') {
            $companyDetails = Employee::where('employeeID', '=', $id)->first();

            $companyDetails->employeeID = $request->employeeID;
            $companyDetails->designation = $request->designation;
            $companyDetails->joiningDate = date('Y-m-d', strtotime($request->joiningDate));
            $companyDetails->exit_date = (trim($request->exit_date) != '') ? date('Y-m-d', strtotime($request->exit_date)) : null;

            $companyDetails->status = ($request->status != 'active') ? 'inactive' : 'active';
           if($request->is_two_leave)
            $companyDetails->is_two_leave=1;
           
           
            $companyDetails->save();
            
              if ($request->salary != '') {
                     $salaryDetails = Salary::where('employeeID', '=', $id)->first();
                     if($salaryDetails){
                    $salaryDetails->type = 'current';
                    $salaryDetails->salary = $request->salary;
                                        $salaryDetails->salary_type = $request->salary_type;
                    $salaryDetails->save();
                     }
                     else
                Salary::create([
                    'employeeID' => $request->employeeID,
                    'type' => 'current',
                    'remarks' => 'Joining Salary Of Employee',
                    'salary' => $request->salary

                ]);
            }

            // if (isset($request->salary)) {
            //     foreach ($request->salary as $index => $value) {
            //         $salaryDetails = Salary::find($index);
            //         $salaryDetails->type = $request->type[$index];
            //         $salaryDetails->salary = $value;
            //         $salaryDetails->save();
            //     }
            // }

            return Reply::success('Company Details updated successfully');

        }

        // Company Details Update End--------------


        // Personal info Details Update Start----------

        else if ($request->updateType == 'personalInfo') {
            $employee = Employee::where('employeeID', '=', $id)->get()->first();

            // Profile Image Upload
            if ($request->profileImage) {
                $file = new Files();
                $filename = $file->upload($request->profileImage, 'employee');
            } else {
                $filename = $request->hiddenImage;
            }

            $employee->update($request->toArray());

            $employee->profileImage = $filename;

            if($request->new_password != ''){
                $employee->password = $request->new_password;
            }

            $employee->save();


            return Reply::success('Updated Successfully');
        }

        // Personal Details Update End-------------

        // Documents info Details Update Start--------
        else if ($request->updateType == 'documents') {
            // UPLOAD THE DOCUMENTS  -----------------
            $documents = ['resume', 'offerLetter', 'joiningLetter', 'contract', 'IDProof'];

            foreach ($documents as $document) {

                if (request()->hasFile($document)) {
                    $file = new Files();
                    $filename = $file->upload(request()->file($document), 'employee_documents/' . $document, null, null, false);
                    $employeeDocument = Employee_document::firstOrNew(['employeeID' => $id, 'type' => $document]);
                    $employeeDocument->fileName = $filename;
                    $employeeDocument->type = $document;
                    $employeeDocument->save();
                }
            }

            return Reply::success('<strong>Success</strong> Updated Successfully');
            // END UPLOAD THE DOCUMENTS**********

        }

        // Documents info Details Update END--------

    }


    public function get_advance($id)
    {
        $this->employeesActive = 'active';
        $this->department = Department::pluck('deptName', 'id');
        $this->employee = Employee::where('employeeID', '=', $id)->get()->first();
        $this->designation = Designation::find($this->employee->designation);

        $this->pending_advance=EmployeeAdvance::where('employee_id',$id)->where('pending_amount','>',0)->sum('pending_amount');

        $this->advance_amount=EmployeeAdvance::where('employee_id',$id)->orderBy('created_at','DESC')->get();




        return View::make('admin.employees.add_advance', $this->data);
    }

    public function update_advance(AdvanceRequest $request,$id)
    {
    
                $input=Request::all();
        // Bank Details Update End--------
        // Company Details Update Start--------
        $currentDate = Carbon::now();
            $e = new EmployeeAdvance();
            $e->employee_id=$id;
           $e->advance_amount=$request->advance_amount;
           $e->deduction=$request->deduction;
           $e->deduct_month=$currentDate->month;
           $e->deduct_year=$currentDate->year;
           $e->pending_amount=$request->advance_amount;

            $e->save();

          

            return Reply::success('Advance Details updated successfully');

        

    }

    public function settle_down()
    {
    
         $id=$_REQUEST['id'];
       
            $e = EmployeeAdvance::where('id', $id)->first();
           $e->pending_amount=0;
           $e->save();

          

           return Response::json(['status'=>1], 200);

        

    }

    // Export Employee Data

    public function export()
    {
        $fileName = 'Employees-' . time() . '.xlsx';
        if (request()->filled('s')) {
            return (new EmployeeExport(request()->input('s')))->download($fileName);
        }
        return (new EmployeeExport)->download($fileName);
    }

    /**
     * @param $id
     * @return array
     * Delete Employee Completely
     */
    public function destroy($id)
    {
        Employee::destroy($id);
        return Reply::success('messages.successDelete');
    }

}
