@extends('admin.adminlayouts.adminlayout')

@section('head')

<!-- BEGIN PAGE LEVEL STYLES -->
{!! HTML::style('assets/global/plugins/bootstrap-fileinput/bootstrap-fileinput.css') !!}
{!! HTML::style('assets/global/plugins/bootstrap-datepicker/css/datepicker3.css') !!}
<!-- END PAGE LEVEL STYLES -->
@stop

@section('mainarea')

<!-- BEGIN PAGE HEADER-->
<h3 class="page-title" xmlns="http://www.w3.org/1999/html">
    Employee Advance </h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="index.html">Home</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="{{route('admin.employees.index')}}">Employees</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="">Edit Advance </a>

        </li>
    </ul>
</div>
<!-- END PAGE HEADER-->
<div class="clearfix">
</div>
<div class="row ">

    <div class="col-md-6 col-sm-6">
        <div class="portlet box red-sunglo">
            <div class="portlet-title">
                <div class="caption">
                    <i class="fa fa-calendar"></i>Advance
                </div>
               
            </div>
            <div class="portlet-body">

                {{--------------------Company Form--------------------------------------------}}
                {!! Form::open(['method' => 'POST','class' => 'form-horizontal','id' => 'advance_form']) !!}
                <div id="company_alert">

                </div>

                <div class="form-group">
                        <label class="col-md-3 control-label">Pending Advance amount:</label>
                        <div class="col-md-9">
                           <h5>{{$pending_advance}}</h5>
                        </div>
                </div>

                <div class="form-body">
                    <div class="form-group">
                        <label class="col-md-3 control-label">Employee ID<span class="required">* </span></label>
                        <div class="col-md-9">
                            <input type="text" name="employeeID" class="form-control" readonly
                                value="{{$employee->employeeID}}">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-md-3 control-label">Advance amount<span class="required">* </span></label>
                        <div class="col-md-9">
                            <input type="text" name="advance_amount" class="form-control"
                                value="">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-md-3 control-label">Monthly deduction<span class="required">* </span></label>
                        <div class="col-md-9">
                            <input type="text" name="deduction" class="form-control"
                                value="">
                        </div>
                    </div>

                 
                   
                   
                    
                   
                    
                   
                   

                    <div class="actions">
                    <a href="javascript:;"
                        onclick="UpdateAdvanceDetails('{!! $employee->employeeID !!}');return false"
                        class="demo-loading-btn-ajax btn btn-sm btn-default ">
                        <i class="fa fa-save"></i> Save </a>
                </div>
                </div>
                {!! Form::close() !!}


                {{----------------Company Form end -------------}}

            </div>
        </div>

       



    </div>

    <div class="col-md-12 col-sm-12">
<h3>Advance History</h3>
<table class="table table-striped table-bordered table-hover" id="sample_employees">
                <thead>
                <tr>
                    <th class="text-center">
                        Sl.no
                    </th>
                    <th class="text-center">
                        Date
                    </th>
                    <th class="text-center">
                        Advance Amount
                    </th>
                    <th class="text-center">
                        Monthly deduction
                    </th>

                    <th class="text-center">
                        Deducted Amount
                    </th>
                    <th class="text-center">
                        Pending Amount
                    </th>
                    <th class="text-center">
                        No of months to Deduct
                    </th>
                    <th class="text-center">
                        Action
                    </th>
                   
                </tr>
                </thead>
                <tbody>
                    <?php $i=1; ?>
                    @foreach($advance_amount as $a)

                <tr>
                <td class="text-center">
                  {{$i}}
                </td>
                <td class="text-center">
                  {{date('d-m-Y H:i:s',strtotime($a->created_at))}}
                </td>
                <td class="text-center">
                  {{$a->advance_amount}}
                </td>
                <td class="text-center">
                  {{$a->deduction}}
                </td>
                <td class="text-center">
                  {{$a->advance_amount-$a->pending_amount}}
                </td>
                <td class="text-center">
                  {{$a->pending_amount}}
                </td>
              
                <td class="text-center">
                  {{ceil($a->pending_amount/$a->deduction)}}
                </td>


                <td class="text-center">
                    @if($a->pending_amount>0)
                 <button class="btn btn-danger" onclick="settle_down('{{$a->id}}')">Settle Down</button>
                 @endif
                </td>

                <?php $i++; ?>
               </tr>
               @endforeach


                </tbody>
            </table>

</div>
</div>

@include('admin.include.delete-modal')
@include('include.show-modal')
{{------------------------------------END NEW SALARY ADD MODALS--------------------------------------}}

@stop

@section('footerjs')

<!-- BEGIN PAGE LEVEL PLUGINS -->
{!! HTML::script('assets/global/plugins/bootstrap-fileinput/bootstrap-fileinput.js') !!}
{!! HTML::script("assets/global/plugins/bootstrap-switch/js/bootstrap-switch.min.js") !!}
{!! HTML::script('assets/global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js') !!}
{!! HTML::script('assets/admin/pages/scripts/components-pickers.js') !!}

<!-- END PAGE LEVEL PLUGINS -->

<script>
    jQuery(document).ready(function () {
        ComponentsPickers.init();
    });


    // Javascript function to update the company info and Bank Info
    function UpdateAdvanceDetails(id) {

        var form_id = '#advance_form';
        var alert_div = '#company_alert';

        var url = "{{ route('admin.employees.update_advance',':id') }}";
        url = url.replace(':id', id);
        $.easyAjax({
            type: 'POST',
            url: url,
            container: form_id,
            file: true,
            alertDiv: alert_div
        });
    }

    // Add New Salary
    function saveSalary(id) {
        var url = "{{ route('admin.salary.store') }}";
        url = url.replace(':id', id);
        $.easyAjax({
            type: 'POST',
            url: url,
            container: '#save_salary',
            data: $('#save_salary').serialize(),
            success: function (response) {
                if (response.status == "success") {
                    $('#showModal').modal('hide');
                    $('#salaryData').append(response.viewData);
                }
            }
        });
    }


    function settle_down(id){
        
            $.ajax( {
                    url: '{{ route("admin.employees.settle_down") }}',
                    type: 'GET',
                    data: {'id':id},
                    success:function(res){
                        if(res.status=1){
                        alert('Payment cleared successfully');
                        window.location.reload();
                        
                        }
                    }
                })
        }

 
</script>

@if(Session::get('successDocuments'))
{{--Move to bottom of page if success comes from documents--}}
<script>
    $("html, body").animate({ scrollTop: $(document).height() }, 2000);
</script>
@endif

@stop