<?php

namespace App\Http\Controllers\Admin;



use App\Events\AttendanceEvent;
use App\Http\Controllers\AdminBaseController;
use App\Http\Requests\Admin\Attendance\UpdateRequest;
use App\Models\Attendance;
use App\Models\Employee;
use App\Models\EmployeeAdvance;
use App\Models\Holiday;
use App\Models\Designation;
use App\Models\Roundoff;
use App\Exports\AttendanceExport;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\View;
use Carbon\Carbon;
use Barryvdh\DomPDF\Options;
use Barryvdh\DomPDF\Facade\Pdf;

/**
 * Class AttendancesController
 * @package App\Http\Controllers\Admin
 */
class PayrollController extends AdminBaseController
{


    public function __construct()
    {
        parent::__construct();
        $this->payrollOpen = 'active open';
        $this->pageTitle = 'PayRoll';
    }

    public function index()
    {
        $this->payrollActive = 'active';
        $this->attendances = Attendance::all();

        $this->date = date('Y-m-d');
        return View::make('admin.payroll.index', $this->data);
    }

    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function ajaxPayrollList()
    {

        $currentDate = Carbon::now();

        $selectedMonth =\request()->month? \request()->month:$currentDate->month; 
$selectedYear = \request()->year? \request()->year:$currentDate->year; 

if (!($selectedYear < $currentDate->year || ($selectedYear == $currentDate->year && $selectedMonth < $currentDate->month))) {
    $selectedMonth =$currentDate->month+1; 
    $selectedYear = $currentDate->year+1; 
}

// Calculate the number of days in the selected month
$numberOfDaysInMonth = cal_days_in_month(CAL_GREGORIAN, $selectedMonth, $selectedYear);

$attendanceDetails = Employee::query()->select(
        'employees.employeeID', 
        'employees.fullName', 
        'salary.salary AS monthly_salary', 
        'salary.salary_type',
        'designation.designation AS designation_name',
        'employees.is_two_leave',
        DB::raw('SUM(CASE WHEN attendance.status = "absent" THEN 1 ELSE 0 END) AS leave_days'),
        DB::raw('SUM(CASE WHEN attendance.is_ot = "1" THEN 1 ELSE 0 END) AS ot_days'),
          DB::raw('SUM(attendance.service_amount) AS total_service_amt'),
         DB::raw('SUM(attendance.spot_amount) AS total_spot_amt')



    )
    ->leftJoin('attendance', 'employees.employeeID', '=', 'attendance.employeeID')
    ->leftJoin('salary', 'employees.employeeID', '=', 'salary.employeeID')
    ->join('designation', 'employees.designation', '=', 'designation.id')
    ->whereYear('attendance.date', $selectedYear)
    ->whereMonth('attendance.date', $selectedMonth)
    ->groupBy('employees.employeeID', 'employees.fullName','salary.salary','designation.designation','employees.is_two_leave')
    ->where('employees.status', 'active');

 $dep_id = \request()->input('department_id');

if (!empty($dep_id)) {
    $dsg_array=Designation::select('id')->where('deptID',$dep_id)->get()->toArray();
    $attendanceDetails->whereIn('employees.designation',$dsg_array);
}


    $searchValue = \request()->input('search.value');

if (!empty($searchValue)) {
    $attendanceDetails->where(function ($subQuery) use ($searchValue) {
                    $subQuery->where('employees.employeeID', 'like', '%' . $searchValue . '%')
                        ->orWhere('employees.email', 'like', '%' . $searchValue . '%')
                        ->orWhere('employees.fullName', 'like', '%' . $searchValue . '%');
                });
}

   




// Fetch the results
$attendanceDetails = $attendanceDetails->get();

// Calculate salary based on attendance and monthly salary
foreach ($attendanceDetails as $attendance) {
    // Calculate the number of working days in the month
    $manager_salary=0;
   global $roundoff_deduction;
   $roundoff_deduction=0;

  

    

    $numberOfWorkingDays = $numberOfDaysInMonth - $attendance->leave_days;  
    $attendance->present_days = $numberOfWorkingDays;
    $attendance->days_in_month = $numberOfDaysInMonth;

if($attendance->salary_type==1)
    $attendance->per_day_salary = ceil($attendance->monthly_salary / $numberOfDaysInMonth);
  if($attendance->salary_type==2)  
    $attendance->per_day_salary=$attendance->monthly_salary;
    
    $attendance->per_day_otsalary = $attendance->per_day_salary*$attendance->ot_days;

    if($attendance->is_two_leave){
        if($attendance->leave_days>2){
            $manager_salary = $attendance->per_day_salary * 2;    
         }
    }

    $r=Roundoff::where('employee_id',$attendance->employeeID)->where('month',$selectedMonth)->where('year',$selectedYear)->first();
    if(empty($r)){
            $r=Roundoff::create(['employee_id'=>$attendance->employeeID,'round_amount'=>0,'month'=>$selectedMonth,'year'=>$selectedYear,'is_advance_deducted'=>0]);
    }
    else
    $roundoff_deduction=$r->round_amount;

   


    $advance_records=EmployeeAdvance::select('employee_advance.*')->where('employee_id',$attendance->employeeID)->where('pending_amount','>',0)->whereDate('created_at','<=',$selectedYear.'-'.$selectedMonth.'-'.$numberOfDaysInMonth)->get();

 $advance_deduction= EmployeeAdvance::where('employee_id',$attendance->employeeID)->where('pending_amount','>',0)->whereDate('created_at','<',$selectedYear.'-'.$selectedMonth.'-'.$numberOfDaysInMonth)->sum('deduction');


 if($r->is_advance_deducted==1)
 $advance_deduction=$r->deducted_amount;
    
 if($r->is_skip_advance==1)
    $advance_deduction=0;



if(count($advance_records)>0){

    if($r->is_advance_deducted ==0 && $r->is_skip_advance==0){
        
        foreach($advance_records as $a){
            $a->pending_amount-=$a->deduction;
            $a->save();
        }

         $r->is_advance_deducted=1;
         $r->deducted_amount=$advance_deduction;
         $r->save();
    }
}


    // Calculate the total salary
    $attendance->total_salary =(($attendance->per_day_salary*$numberOfWorkingDays) +  $manager_salary+ $attendance->per_day_otsalary+$roundoff_deduction+$attendance->total_service_amt+$attendance->total_spot_amt)-($advance_deduction);
    $attendance->round_off=$roundoff_deduction;
    $attendance->round_off_id=$r->id;
    $attendance->monthly_deduction=$advance_deduction;
    $attendance->skip_advance=$r->is_skip_advance;
    // Assign present days
}

// Prepare the DataTable response
return datatables()->of($attendanceDetails)
->addColumn('present_days', function ($attendance) {
    return $attendance->present_days;
})
    
    ->addColumn('total_salary', function ($attendance) {
        return $attendance->total_salary;
    })
    ->editColumn('salary_type', function ($attendance) {
        return $attendance->salary_type==2?'Daily':'Monthly';
    })
    ->addColumn('days_in_month', function ($attendance) {
        return $attendance->days_in_month;
    })
    ->addColumn('per_day_salary', function ($attendance) {
        return $attendance->per_day_salary;
    })
    ->addColumn('per_day_otsalary', function ($attendance) {
        return $attendance->per_day_otsalary;
    })
    ->addColumn('round_off', function ($attendance) {
        return '<div class="d-flex align-items-center"><input style="width:60px" id="round'.$attendance->round_off_id.'" type="number" value="'.$attendance->round_off.'"><button onclick="save_roundoff('.$attendance->round_off_id.')" class="ml-1 btn btn-success"><i class="fa fa-save"></i></button></div>';
    })
    ->addColumn('skip_advance', function ($attendance) {
        return '<input id="skip'.$attendance->round_off_id.'" onchange="skip_advance('.$attendance->round_off_id.')" type="checkbox" value="1" '.($attendance->skip_advance==1?'checked':'').'>';
    })
    ->addColumn('payslip', function ($attendance) {
        return '<button onclick="download_payslip(\''.$attendance->employeeID.'\',\''.$attendance->per_day_otsalary.'\',\''.$attendance->round_off.'\',\''.$attendance->monthly_deduction.'\','.$attendance->total_salary.')" class="mt-2 btn btn-success">Download</button>';
    })
    
    
    ->removeColumn('profile_image_url') // Assuming you have a column named 'profile_image_url' to remove
    ->rawColumns(['round_off','skip_advance','payslip']) // Assuming you have a column named 'profile_image_url' to remove

    ->make(true);
    }


    /**
     * @return \Illuminate\Http\RedirectResponse
     * This method is called when we mark the attendance and redirects to edit page.
     */

    public function create()
    {
        $date = (\request()->date != '') ? \request()->date : date('Y-m-d');
        $date = date('Y-m-d', strtotime($date));

        $attendance_count = Attendance::where('date', '=', $date)->count();
        $employee_count = Employee::active()->count();

        if ($employee_count == $attendance_count) {
            if (!Session::get('success')) {
                Session::flash('success', '<strong>Attendance already marked</strong>');
            }

        } else {
            Session::forget('success');
        }

        return Redirect::route('admin.attendances.edit', $date);
    }

    /**
     * Display the specified attendance
     */
    public function show($id)
    {
        $this->viewAttendanceActive = 'active';

        $this->employee = Employee::where('employeeID', '=', $id)->get()->first();
        $this->attendance = Attendance::where('employeeID', '=', $id)
            ->where(function ($query) {
                $query->where('application_status', '=', 'approved')
                    ->orwhere('application_status', '=', null)
                    ->orwhere('status', '=', 'present');
            })->get();
        $this->holidays = Holiday::all();
        $this->employeeslist = Employee::pluck('fullName', 'employeeID');


        return View::make('admin.attendances.show', $this->data);
    }

    /**
     * Show the form for editing the specified attendance.
     */
    public function edit($date)
    {
        $attendanceArray = [];
        $this->attendance = Attendance::where('date', '=', $date)->get()->toArray();

        $this->todays_holidays = Holiday::where('date', '=', $date)->get()->first();

        foreach ($this->attendance as $attend) {
            $attendanceArray[$attend['employeeID']] = $attend;
        }

        $this->date = $date;
        $this->attendanceArray = $attendanceArray;


        $this->leaveTypes = Attendance::leaveTypesEmployees();
        $this->leaveTypeWithoutHalfDay = Attendance::leaveTypesEmployees('half day');
        $this->employees = Employee::active()->get();

        return View::make('admin.attendances.edit', $this->data);
    }

    /**
     * Update the specified attendance in storage.
     */
    public function update(UpdateRequest $request, $date)
    {
        $input = Request::all();

        foreach ($input['employees'] as $employeeID) {

            $user = Attendance::firstOrCreate([
                'employeeID' => $employeeID,
                'date' => $date,
            ]);
            if ($user->application_status != 'approved' || ($user->application_status == 'approved' && isset($input['checkbox'][$employeeID]) == 'on')) {
                $update = Attendance::find($user->id);
                $update->status = (isset($input['checkbox'][$employeeID]) == 'on') ? 'present' : 'absent';
                $update->leaveType = (isset($input['checkbox'][$employeeID]) == 'on') ? null : $input['leaveType'][$employeeID];
                $update->halfDayType = ((!isset($input['checkbox'][$employeeID]) == 'on') && ($input['leaveType'][$employeeID] == 'half day')) ? $input['leaveTypeWithoutHalfDay'][$employeeID] : null;
                $update->reason = (isset($input['checkbox'][$employeeID]) == 'on') ? '' : $input['reason'][$employeeID];
                $update->application_status = null;
                $update->updated_by = Auth::guard('admin')->user()->email;
                $update->save();
            }

        }

        $this->date = date('d M Y', strtotime($date));

        if ($this->setting->attendance_notification == 1) {

            $employees = Employee::select('id', 'email', 'fullName')->active()->get();

            foreach ($employees as $employee) {
                $this->employee_name = $employee->fullName;
                event(new AttendanceEvent($employee, $this->date));
            }
        }

        Session::flash('success', date('d M Y', strtotime($date)) . 'successfully Updated');
        return Redirect::route('admin.attendances.edit', $date);
    }

    public function export()
    {
        $fileName = 'Attendance-' . time() . '.xlsx';
        if (request()->filled('s')) {
            return (new AttendanceExport(request()->input('s')))->download($fileName);
        }
        return (new AttendanceExport)->download($fileName);
    }

    public function report()
    {

        $month = Request::get('month');
        $year = Request::get('year');
        $employeeID = Request::get('employeeID');

        $firstDay = $year . '-' . $month . '-01';


        $presentCount = Attendance::countPresentDays($month, $year, $employeeID);

        $totalDays = date('t', strtotime($firstDay));

        $holidaycount = count(DB::select(DB::raw('select * from holidays where MONTH(date)=' . $month)));
        $workingDays = $totalDays - $holidaycount;


        $percentage = ($presentCount / $workingDays) * 100;
        $output['success'] = 'success';
        $output['presentByWorking'] = $presentCount.'/'.$workingDays;

        $output['attendancePerReport'] = number_format((float)$percentage, 2, '.', '');
        return Response::json($output, 200);

    }

    /**
     * Remove the specified attendance from storage.
     */
    public function destroy($id)
    {
        Attendance::destroy($id);
        return Redirect::route('admin.attendances.index');
    }

    public function save_round_off(){
        $r=Roundoff::where('id',$_REQUEST['id'])->update(['round_amount'=>$_REQUEST['amount']]);
        return Response::json(['status'=>1], 200);

    }

    public function skip_advance(){
        $r=Roundoff::where('id',$_REQUEST['id'])->update(['is_skip_advance'=>$_REQUEST['skip_advance']]);
        return Response::json(['status'=>1], 200);

    }
    public function download_payslip()
    {

        $e=Employee::select(
            'employees.employeeID', 
            'employees.fullName', 
            'salary.salary AS monthly_salary', 
            'designation.designation AS designation_name')->where('employees.employeeID',$_REQUEST['id']) 
        ->leftJoin('salary', 'employees.employeeID', '=', 'salary.employeeID')
        ->join('designation', 'employees.designation', '=', 'designation.id')->first();
        // Assuming you have your payslip data here
        $data = [
            'employeeName' => $e->fullName,
            'employeeId' => $_REQUEST['id'],
            'month' =>  $_REQUEST['month'].'/'. $_REQUEST['year'],
            'basicSalary' => $e->monthly_salary,
            'ot_salary' => $_REQUEST['ot_salary'],
            'round_off'=>$_REQUEST['round_off'],
            'deductions' =>$_REQUEST['deduction'],
            'totalSalary' => $_REQUEST['total_salary'],
        ];

        // $data=[];

        // Configure DomPDF options
        // $options = new Options();
        // $options->set('isHtml5ParserEnabled', true);
        // $options->set('isPhpEnabled', true);
        // $options->set('defaultFont', 'Arial');
        // $options->set('isRemoteEnabled', true);
        // $options->setPaper('A4', 'portrait'); // Set paper size to A4

        // Pass the options to the PDF instance
      //  $pdf = PDF::setOptions();

        // Load the payslip view with data
        $pdf=PDF::loadView('admin.payroll.payslip', $data);

        // Generate PDF and download
        return $pdf->download($e->fullName.'_payslip.pdf');
    }


}
