@extends('admin.adminlayouts.adminlayout')

@section('head')
    <!-- BEGIN PAGE LEVEL STYLES -->
    {!! HTML::style("assets/global/plugins/bootstrap-datepicker/css/datepicker3.css") !!}
    {!! HTML::style("assets/global/plugins/select2/select2.css") !!}
    {!! HTML::style("assets/global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.css") !!}
    <!-- END PAGE LEVEL STYLES -->
    <style>
        .tools {
            padding: 5px;
        }

        .btn-group {
            margin-right: 10px;
        }
    </style>
@stop

@section('mainarea')

    <!-- BEGIN PAGE HEADER-->
    <h3 class="page-title">
        {{$pageTitle}} <small>Employee List</small>
    </h3>
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <i class="fa fa-home"></i>
                <a href="{{route('admin.dashboard.index')}}">Home</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li>
                <a href="{{route('admin.payroll.index')}}">Payroll</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li>
                <a href="#">payroll</a>
            </li>
        </ul>

    </div>
    <!-- END PAGE HEADER-->
    <!-- BEGIN PAGE CONTENT-->

    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div id="load">

                @if(Session::get('success'))
                    <div class="alert alert-success">{!! Session::get('success') !!} </div>
                @endif

            </div>

            <div class="row">
                <div class="col-md-12">
                <label for="year">Select Year:</label>
    <select  name="year" id="year">
    <option value="">Select</option>

        @for ($i = date("Y"); $i <= date("Y")+2; $i++)
            <option value="{{ $i }}">{{ $i }}</option>
        @endfor
    </select>
                <label for="month">Select Month:</label>
    <select name="month" id="month">
    <option value="">Select</option>

        @for ($i = 1; $i <= 12; $i++)
            <option value="{{ $i }}" {{$i < date("n")-1?'disabled':''}}>{{ date("F", mktime(0, 0, 0, $i, 1)) }}</option>
        @endfor
    </select>
    
        <label for="month">Department:</label>
    <select name="department_id" id="department_id">
    <option value="">Select</option>

        @foreach (\App\Models\Department::get() as $d)
            <option value="{{ $d->id }}">{{$d->deptName}}</option>
        @endforeach
    </select>


  


                        <button class="btn blue" type="button" onclick="$('#sample_1').DataTable().ajax.reload();">Show PayRoll</button>
                    </div>

                </div>
              


            </div>


            <hr>
            <div class="portlet box blue">

                <div class="portlet-title">
                    <div class="caption">
                        <i class="fa fa-users"></i>Payroll
                    </div>
                    <!-- <div class="tools">
                        <form id="attendanceExport" method="POST">
                            {{ csrf_field() }}
                            <div class="btn-group pull-right">
                                <button type="submit" class="btn yellow"><i class="fa fa-file-excel-o"></i> Export
                                </button>
                            </div>
                            <div class="btn-group pull-right">
                                <div class="input-daterange input-group">
                                    <input type="text" class="input-md form-control" name="start"/>
                                    <span class="input-group-addon">to</span>
                                    <input type="text" class="input-md form-control" name="end"/>
                                </div>
                            </div>
                        </form>
                    </div> -->
                </div>

                <div class="portlet-body" style="overflow-x:scroll">

                    <table class="table table-striped table-bordered table-responsive table-hover" id="sample_1">
                        <div>
    <label for="searchInput">Search:</label>
    <input type="text" id="searchInput" placeholder="Search...">
</div>
                        <thead>
                        <tr>
                            <th style="width:30px"> Employee ID</th>
                            <th style="width:180px"> Name</th>
                            <th style="width:140px">Designation</th>
                            <th style="width:30px"> Salary</th>
                            <th style="width:50px">Salary Type</th>
                            <th style="width:30px"> Working Days</th>
                            <th style="width:30px"> Leave Days</th>
                            <th style="width:40px">No of OT</th>
                            <th style="width:30px">OT Salary</th>
                                                        <th style="width:30px">Service Amount</th>
                                                                                    <th style="width:30px">Spot Amount</th>


                            <th style="width:80px">Advance deduction</th>
                            <th class="no-export" style="width:30px">Skip Advance</th>
                            
                            <th class="no-export" style="width:120px">RoundOff</th>
                            <th style="width:30px">Total Salary</th>
                            <th class="no-export" style="width:30px">Payslip</th>





                            
                        </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->

        </div>
    </div>
    <!-- END PAGE CONTENT-->

    {{--DELETE MODAL CALLING--}}
    @include('admin.common.delete')
    {{--DELETE MODAL CALLING END--}}

@stop


@section('footerjs')

    <!-- BEGIN PAGE LEVEL PLUGINS -->
    {!! HTML::script("assets/global/plugins/select2/select2.min.js") !!}
    {!! HTML::script("assets/global/plugins/datatables/media/js/jquery.dataTables.min.js") !!}
    {!! HTML::script("assets/global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js") !!}
    {!! HTML::script("assets/admin/pages/scripts/table-managed.js") !!}
    {!! HTML::script("assets/global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js") !!}
    {!! HTML::script("assets/admin/pages/scripts/components-pickers.js") !!}

<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">

    <!-- END PAGE LEVEL PLUGINS -->

    <script>
        var table = $('#sample_1');

        jQuery(document).ready(function () {
            ComponentsPickers.init();
            attendanceList();
        });

       

        function attendanceList() {
            var td=table.DataTable({
                
                "cache": true,
                "bProcessing": true,
                "colReorder": true,
                "bServerSide": true,
                "bDestroy": true,                
                ajax: {
                    url: '{{ route("admin.payroll.ajax-payroll-list") }}',
                    type: 'GET',
                    data: function (data) {
                        data.month = $('#month').val();
                        data.year= $("#year").val();    
                       data.department_id= $("#department_id").val();       

                    },
                },
                
                columns: [
                    {data: 'employeeID'},
                    {data: 'fullName'},
                    {data: 'designation_name'},
                    {data: 'monthly_salary'},
                    {data: 'salary_type'},
                    {data: 'present_days'},
                    {data: 'leave_days'},
                    {data: 'ot_days'},
                    {data: 'per_day_otsalary'},
                    {data: 'total_service_amt'},
                    {data: 'total_spot_amt'},
                    {data: 'monthly_deduction'},
                    {data: 'skip_advance'},
                    {data: 'round_off'},
                    {data: 'total_salary'},
                    {data: 'payslip'},

                    
                ],

                dom: 'lB<"clearfix">ps',
                buttons: [
                    {
                extend: 'pdfHtml5',
                text: 'Download PDF',
                title: function() {
                    return 'Kongu Mess Employee Payroll ('+$('#year').val()+'-'+$("#month").val()+')'
                },
                filename: function() {
                    return 'kongu Mess Payroll ('+$('#year').val()+'-'+$("#month").val()+')'; // Specify your custom filename here
                },
                exportOptions: {
                    columns: ':not(.no-export)'
                }
            },
            {
        extend: 'excelHtml5',
        text: 'Download Excel',
        title: function() {
            return 'Kongu Mess Employee Payroll ('+$('#year').val()+'-'+$("#month").val()+')';
        },
        filename: function() {
            return 'kongu Mess Payroll ('+$('#year').val()+'-'+$("#month").val()+')'; // Specify your custom filename here
        },
        exportOptions: {
            columns: ':not(.no-export)'
        }
    }
        ],
        "lengthMenu": [ [10, 25, 50,100, -1], [10, 25, 50,100, "All"] ],

                "fnRowCallback": function (nRow, aData, iDisplayIndex) {
                    //				var row = $(nRow);
                    //				row.attr("id", 'row'+aData['0']);
                },
                "fnDrawCallback": function () {
                    Metronic.init();
                },
                "sPaginationType": "full_numbers",
                "language": {
                    "emptyTable": "No Payroll generated for this month"
                },
                "fnInitComplete": function (oSettings, json) {
                    Metronic.init();
                },
                
            });
            
             // Custom search input binding
    $('#searchInput').on('keyup', function() {
        td.search(this.value).draw();
    });

            

          

        }

        $('#attendanceExport').submit(function (e) {
            var form = $(this);

            var searchValue = $('.dataTables_filter input').val();
            var url = '{{ route("admin.attendance.export") }}?s=' + searchValue;

            form.attr('action', url);
        });

        function save_roundoff(id){
            console.log($("#round"+id).val());
            if($("#round"+id).val() == ''){
            alert('Please enter value');
            return 0;
            }
            $.ajax( {
                    url: '{{ route("admin.payroll.save_round_off") }}',
                    type: 'GET',
                    data: {'id':id,'amount':$("#round"+id).val()},
                    success:function(res){
                        if(res.status=1){
                        alert('saved successfully');
                        $('#sample_1').DataTable().ajax.reload();
                        }
                    }
                })
        }

        function skip_advance(id){
            console.log($("#skip"+id).val());
            if($("#skip"+id).prop('checked')){
                var skip=1;
            }
            else
            var skip=0;


           
            $.ajax( {
                    url: '{{ route("admin.payroll.skip_advance") }}',
                    type: 'GET',
                    data: {'id':id,'skip_advance':skip},
                    success:function(res){
                        if(res.status=1){
                        alert('saved successfully');
                        $('#sample_1').DataTable().ajax.reload();
                        }
                    }
                })
        }

        function download_payslip(id,ot_salary,roundoff,advance,total_salary){
            // console.log($("#round"+id).val());
            // if($("#round"+id).val() == ''){
            // alert('Please enter value');
            // return 0;
            // }
            $.ajax( {
                
                    url: '{{ route("admin.payroll.download_payslip") }}',
                    type: 'GET',
                    enctype: "multipart/form-data",
                    data: {'id':id,'ot_salary':ot_salary,'round_off':roundoff,'deduction':advance,'total_salary':total_salary,'month':$('#month').val(),'year':$('#year').val()},
                    xhrFields: {
                        responseType: 'blob'
                    },
                    success: function(response) {
                        var a = document.createElement('a');
                        var url = window.URL.createObjectURL(response);
                        a.href = url;
                        a.download = 'file.pdf';
                        document.body.append(a);
                        a.click();
                        a.remove();
                        window.URL.revokeObjectURL(url);
                        // Swal.fire("Sale generated successfully");
                    },
                })
        }
    </script>

@stop
