<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payslip</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .container {
            max-width: 800px;
            margin: 20px auto;
            padding: 20px;
            border-radius: 5px;
            background-color: #fff;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header h2 {
            color: #333;
            margin: 0;
        }
        .company-details {
            margin-bottom: 30px;
        }
        .company-details h3 {
            color: #333;
            margin: 0 0 5px 0;
        }
        .company-details p {
            color: #777;
            margin: 0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            padding: 10px;
            border-bottom: 1px solid #ddd;
            color: #555;
        }
        th {
            text-align: left;
            background-color: #f2f2f2;
        }
        .total {
            font-weight: bold;
            text-align: right;
        }
        .footer {
            text-align: center;
            color: #777;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Payslip</h2>
        </div>
        <div class="company-details">
            <h3>Company Details</h3>
            <p>Company Name: KONGU MESS</p>
            <p>Email: info@kongumess.com</p>
        </div>
        <table>
            <tr>
                <th>Employee Name</th>
                <td><?php echo e($employeeName); ?></td>
            </tr>
            <tr>
                <th>Employee ID</th>
                <td><?php echo e($employeeId); ?></td>
            </tr>
            <tr>
                <th>Month</th>
                <td><?php echo e($month); ?></td>
            </tr>
            <tr>
                <th>Basic Salary</th>
                <td><?php echo e($basicSalary); ?></td>
            </tr>
            <tr>
                <th>OT Salary</th>
                <td><?php echo e($ot_salary); ?></td>
            </tr>
            <tr>
                <th>Deductions</th>
                <td><?php echo e($deductions); ?></td>
            </tr>
            <tr class="total">
                <th>Total Salary</th>
                <td><?php echo e($totalSalary); ?></td>
            </tr>
        </table>
        <div class="footer">
            <p>This is a computer-generated document and does not require a signature.</p>
        </div>
    </div>
</body>
</html><?php /**PATH /home5/weberpos/hrm.weberpos.com/resources/views/admin/payroll/payslip.blade.php ENDPATH**/ ?>